package com.qboxus.tictic.activitesfragments.profile.settings

import android.content.Intent
import android.graphics.Rect
import android.os.Bundle
import android.text.Editable
import android.text.TextUtils
import android.text.TextWatcher
import android.view.MotionEvent
import android.view.View
import android.view.inputmethod.InputMethodManager
import android.widget.EditText
import android.widget.TextView
import androidx.lifecycle.ViewModelProvider
import com.qboxus.tictic.R
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.databinding.ActivityAddPayoutMethodBinding
import com.qboxus.tictic.repositories.WalletRepository
import com.qboxus.tictic.simpleclasses.AppCompatLocaleActivity
import com.qboxus.tictic.simpleclasses.Functions.getSharedPreference
import com.qboxus.tictic.simpleclasses.Functions.isValidEmail
import com.qboxus.tictic.simpleclasses.Functions.setLocale
import com.qboxus.tictic.simpleclasses.Variables
import com.qboxus.tictic.viewModels.AddPayoutFactory
import com.qboxus.tictic.viewModels.AddPayoutViewModel

class AddPayoutMethodActivity : AppCompatLocaleActivity(), View.OnClickListener {
    var headingText: TextView? = null
    var type: String? = "Paypal"
    lateinit var binding: ActivityAddPayoutMethodBinding

    private val walletRepository = WalletRepository()
    lateinit var viewModel: AddPayoutViewModel
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setLocale(
            getSharedPreference(this@AddPayoutMethodActivity).getString(
                Variables.APP_LANGUAGE_CODE,
                Variables.DEFAULT_LANGUAGE_CODE
            ),
            this, javaClass, false
        )
        binding = ActivityAddPayoutMethodBinding.inflate(layoutInflater)
        setContentView(binding.root)

        val viewModelProvidefactory = AddPayoutFactory(this, walletRepository)
        viewModel = ViewModelProvider(
            this, viewModelProvidefactory
        )[AddPayoutViewModel::class.java]

        InitControl()
        ActionContorl()
        initObserver()
    }
    fun initObserver(){
        viewModel.payoutLiveData.observe(this) {
            when (it) {
                is ApiResponce.Success -> {
                    it.data?.let { list ->
                        list.forEach {
                            val editor = getSharedPreference(this@AddPayoutMethodActivity).edit()
                            editor.putString(Variables.U_PAYOUT_ID, it.paypal)
                            editor.commit()
                            val intent = Intent()
                            intent.putExtra("isShow", true)
                            setResult(RESULT_OK, intent)
                            finish()
                        }
                    }
                }
                else -> {

                }
            }
        }
    }

    private fun ActionContorl() {
        binding.etEmail.addTextChangedListener(object : TextWatcher {
            override fun beforeTextChanged(charSequence: CharSequence, i: Int, i1: Int, i2: Int) {}
            override fun onTextChanged(charSequence: CharSequence, i: Int, i1: Int, count: Int) {
                // check the email validation during user typing
                val txtName = binding.etEmail.text.toString()
                if (txtName.length > 0) {
                    if (isValidEmail(binding.etEmail.text.toString())) {
                        binding.btnAdd.isEnabled = true
                        binding.btnAdd.isClickable = true
                    } else {
                        binding.btnAdd.isEnabled = false
                        binding.btnAdd.isClickable = false
                    }
                } else {
                    binding.btnAdd.isEnabled = false
                    binding.btnAdd.isClickable = false
                }
            }

            override fun afterTextChanged(editable: Editable) {}
        })
    }

    private fun InitControl() {
        headingText = findViewById(R.id.headingtext)
        binding.btnAdd.setOnClickListener(this)
        findViewById<View>(R.id.goBack1).setOnClickListener(this)
        SetupScreenData()
    }

    private fun SetupScreenData() {
        if (intent.getBooleanExtra("isEdit", false)) {
            if (intent.hasExtra("type")) {
                type = intent.getStringExtra("type")
                headingText!!.text =
                    getString(R.string.enter_your) + " " + type + " " + getString(R.string.email_address)
            }
            binding.etEmail.setText(intent.getStringExtra("email"))
            binding.btnAdd.text = getString(R.string.update_payout)
        } else if (intent.hasExtra("type")) {
            type = intent.getStringExtra("type")
            headingText!!.text =
                getString(R.string.enter_your) + " " + type + " " + getString(R.string.email_address)
        } else {
            binding.btnAdd.text = getString(R.string.add_payout)
        }
    }

    override fun onClick(view: View) {
        when (view.id) {
            R.id.goBack1 -> super@AddPayoutMethodActivity.onBackPressed()
            R.id.btnAdd -> {
                if (TextUtils.isEmpty(binding.etEmail.text.toString())) {
                    binding.etEmail.error = getString(R.string.email_cant_empty)
                    binding.etEmail.isFocusable = true
                    return
                }
                if (!isValidEmail(binding.etEmail.text.toString())) {
                    binding.etEmail.error = getString(R.string.enter_valid_email)
                    binding.etEmail.isFocusable = true
                    return
                }
                viewModel.addPayout(type!!,binding.etEmail.text.toString())
            }
        }
    }

    override fun dispatchTouchEvent(event: MotionEvent): Boolean {
        if (event.action == MotionEvent.ACTION_DOWN) {
            val v = currentFocus
            if (v is EditText) {
                val outRect = Rect()
                v.getGlobalVisibleRect(outRect)
                if (!outRect.contains(event.rawX.toInt(), event.rawY.toInt())) {
                    v.clearFocus()
                    hideKeyboard(v)
                }
            }
        }
        return super.dispatchTouchEvent(event)
    }

    fun hideKeyboard(view: View) {
        val imm = getSystemService(INPUT_METHOD_SERVICE) as InputMethodManager
        imm.hideSoftInputFromWindow(view.windowToken, 0)
    }
}